<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeamMembers extends Model 
{

    protected $table = 'team_members';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function team()
    {
        return $this->belongsTo('App\Models\Team', 'team_id', 'id');
    }

    public function users()
    {
        return $this->hasMany('App\Models\User', 'user_id', 'id');
    }

}